// QQ导航 iframe 跨域自适应高度
window.addEventListener('message', function(event) {
	var data = event.data;
	var iframe = document.getElementById('iframe-website-navigation');
	if (iframe !== null) {
		iframe.height = data + 'px';
	}
}, false);

document.getElementById('mask-close').addEventListener('click', function() {
	document.getElementById('mask').style.display = 'none';
	document.body.classList.remove('no-scroll');
}, false);

var home = {
    // 用一个随机的时间值作为 ID 来区分同时打开的多个主页
    instanceId: (new Date()).getTime(),
    
    _cellContainers:new Array(),
    _childPagesBind:new Array(),
    _childPagesBindClick:new Array(),
    _childPages: new Array(),
    
    _this:this,
    hasLoadSites: false,
	hasLoadTerritory: false,
	hasLoadCusCells: false,
	hasLoadTopCells: false,
    searchInputEle:null,
    searchButtonEle:null,
    searchUrl:null,
    searchChangeBind:function(){},
   
    getSearchUrl:function(se){
    	var url = {
		    'google':'http://www.google.com.hk/search?hl=zh-CN&q=',
		    'baidu':'http://www.baidu.com/s?wd=',
		    'soso':'http://www.soso.com/q?ie=utf-8&oe=utf-8&tin=tin&cid=qb.zy&w='
    	};
    	return url[se];
    },
    getSearchTip:function(se){
    	var url = {
		    'google':'使用谷歌搜索',
		    'baidu':'百度一下，你就知道',
		    'soso':'搜搜更懂你'
    	};
    	return url[se];
    },
    status:new (function(){
    	var status ={
    		'currentPage':  1,   //0 cells,1 siteList ,  2 territory
    		'currentCells': 0	//0 topsites,1 custom
    	};
    	this.setStatus = function(index,value){
    		status[index] = ((typeof value === "number" && !isNaN(value))? value : status[index]);
    	};
    	this.getStatus = function(index){
    		return status[index];
    	};
    })(), 
    
    init: function(){

    	this.initStatus();
    	this.initListener();
    	this.initSkin();
    	
    	//上报首页打开数据
    	browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_OPEN);
    	browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQHOME_MOST_VISITED_SHOW + this.status.getStatus('currentPage'));
    	browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQHOME_MENUITEM_MOST_VISITED + this.status.getStatus('currentCells'));
    },
    
	initListener: function() {
		var _this = this;
        try { 
	        	/**
	        	 * 除地址栏以及查找栏之外，禁止全选及拖拽
	        	 */
	        	document.onselectstart = function() {
	        		if(!event.target.id || event.target.id.indexOf("input") === -1) {
	        			return false;
	        		}
	        	};
	        	document.ondragstart = function() {
	        		return false;
	        	};
                document.onmousedown = function(){

	                 if(event.button==1){

			         event.preventDefault();
		              return false;

		   }
	    };
				// when search engine config change
				qqbrowser.extension.builtin.config.onConfigChanged.addListener(function(ret){
						_this.initSearch();
				});
				//隐藏所有的menu
				document.onclick = function(){
					qqbrowser.js.tools.utils.addClass($(".se-menu")[0],"hide");
					qqbrowser.js.tools.utils.addClass($(".menu")[0],"hide");
				};	
				//snapshot自适应
				window.onresize = function(){
					if(!_this.cellAnimateInited)
					{
						_this.initCellsAnimate();
					}
					_this.initCellSize();
				};
				//子页面数据上报
				window.addEventListener('message',function(e){
					if(typeof e.data === "string" && e.data === "index")
					{
						browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQHOT_TOTAL_CLICKED );
					}else if(e.data.index && e.data.page === 'territory'){
						browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQAPP_TOTAL_CLICKED );
						var i = parseInt(e.data.index);
						i-=1;
						if(i<20){
							browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQAPP_QQHOT_CELL_CLICKED_BASE+i);
						}else{
							i-=20;
							browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQAPP_OTHER_LINK_CLICKED_BASE+i);
						}
							
					}
				}, false);
				//在这里添加换肤事件监听
				//_this.intiSkin();
		}catch(err){

		}
	},
	initChildPagesBindClick:function(){
		for(var i=0;i<this._childPagesBind.length;++i){
			this._childPagesBindClick[i] = function(event){};
		}
	},
	initSearch: function() {
		var _this = this;		   
		try{
			var req=['searchSelect'];
			var defaultSE = localStorage.getItem('defaultSE');
			if(defaultSE){
				home.searchUrl = _this.getSearchUrl(defaultSE);
				getId("cur-se").style.background ="url(images/se-logo/" + defaultSE +".png) no-repeat";
				getId("search-input").placeholder = _this.getSearchTip(defaultSE);
			}
			qqbrowser.extension.builtin.config.get(req,function(ret){
				var res= eval( "( " +ret+ " ) " );
				if(defaultSE !== res[0]['searchSelect']){
					home.searchUrl = _this.getSearchUrl(res[0]['searchSelect']);
					getId("cur-se").style.background ="url(images/se-logo/" + res[0]['searchSelect'] +".png) no-repeat";
					getId("search-input").placeholder = _this.getSearchTip(res[0]['searchSelect']);
					localStorage.setItem('defaultSE',res[0]['searchSelect']);
				}
			});
		}catch(err){
			this.searchUrl = this.getSearchUrl('soso');	
			getId("cur-se").style.background ="url(images/se-logo/soso.png) no-repeat";
			getId("search-input").placeholder = this.getSearchTip('soso');
		}
		//event bind
		if(this.searchButtonEle && this.searchInputEle){
			this.searchButtonEle.addEventListener('click',function(){_this.dosearch(_this.searchInputEle.value);},false);
		}
		if(this.searchInputEle){
			this.searchInputEle.addEventListener('keydown',function(e){
				e = e || window.event;
				var keycode = e.which ? e.which : e.keyCode;
				if (keycode == 13 || keycode == 108){ //如果按下ENTER键
					_this.dosearch(this.value);
				}				
			},false);
		}
		this.searchChangeBind();
	},
	searchChange: function (v){
		var obj=new Object();
		obj.searchSelect=v;
		try{
			qqbrowser.extension.builtin.config.set(obj,function(){});
		}catch(err){
			throw err;
		}
	},
	dosearch: function(word) {
		var searchword = encodeURIComponent(word);
		var searchUrl = home.searchUrl;
		if(word == ""){
			searchUrl = home.searchUrl.replace(/\/\w*?\?[\w\W]*$/,'');
		}
		var url = searchUrl+searchword;
		
		//数据上报
		browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_SEARCH_USED);
		if(/soso/.test(searchUrl)){
			browser.dataReport.increase(DATAREPORT.STATIS_CMD_SOSO_SEARCH_HOMEPAGE_PAGE_SEARCH);
		}else if(/google/.test(searchUrl)){
			browser.dataReport.increase(DATAREPORT.STATIS_CMD_GOOGLE_SEARCH_HOMEPAGE_PAGE_SEARCH );
		}else{
			browser.dataReport.increase(DATAREPORT.STATIS_CMD_BAIDU_SEARCH_HOMEPAGE_PAGE_SEARCH);
		}
		
		location.href=url;
	},
	//tab页面切换
	childPageListener: function(){
		var _this = this;
        var utils = qqbrowser.js.tools.utils;
		var isSelcet = utils.hasClass(getId("content"),"pageSelected");
		try{
		for(var i=0;i<this._childPagesBind.length;++i){
			(function(i){
				var index = i;
				_this._childPagesBind[i].addEventListener('click',function(event){
					// 因为首页显示哪个Tab，需要读取config(home.initStatus)，config异步回调函数中去显示Tab
					// 如果在异步回调之前用户点击Tab，则记一个标志位，config的异步回调函数检测到标志位就跳出代码
					home.userClickFag = true;
					
					if(!isSelcet)
					{
						utils.addClass(getId("content"),"pageSelected");
						isSelcet = true;
					}
					for(var j=0;j< _this._childPages.length;++j){
						utils.addClass(_this._childPages[j],"hide");
						utils.removeClass(_this._childPagesBind[j],"cur-page");
					};
					if(!utils.hasClass(_this._childPagesBind[index],"cur-page")){
						utils.removeClass(_this._childPages[index],"hide");
						utils.addClass(_this._childPagesBind[index],"cur-page");
                       if(index == 1 && !home.hasLoadSites){
                           utils.addClass(document.body,"notcell");
							home.loadSiteList();
						}
						else if(index == 2 && !home.hasLoadTerritory){
                           utils.addClass(document.body,"notcell");
							home.loadTerritory();
						}else if(index === 0){
                           //utils.removeClass(document.body,"notcell");
                           var currentCells = home.status.getStatus('currentCells');
                           if(currentCells === 0&&!home.hasLoadTopCells){
                               cellManager.topsitesManage();//add by cris 按需加载
                               home.initCellSize();
                                cellManager.cellButtonsManage();
                           } else if(!home.hasLoadCusCells) {
                               cellManager.customsitesManage();
                               home.initCellSize();
                               cellManager.cellButtonsManage();
                           }
                       }
                        
						//子页面点击数据上报
						//browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQHOME_MOST_VISITED_SHOW + index);
					}
					//调用外部设定的事件
					_this._childPagesBindClick[index](event);
					_this.status.setStatus('currentPage',index);
					_this.saveStatus();
					if (index == 1) {
						document.getElementById('search-bar').style.display = 'none';
					} else {
						document.getElementById('search-bar').style.display = '';
					}
				});
			})(i);
		}}catch(e){
			console.log(e);
		}
	},
	initCellSize:function(){
		//可考虑将这部分代码提出到css中，规范之
		var snapshot = $(".snapshot");
		var height = document.body.clientHeight;
		var width = document.body.clientWidth;
		var title = $(".cell-title");
        var topsiteCells = getId("topsiteCells");
        var customsiteCells =  getId("customsiteCells");
		if(height <= 720){
			topsiteCells&&(topsiteCells.style.width = "750px");
			customsiteCells&&(customsiteCells.style.width = "750px");
			for(var i = 0;i<$(".home-tabpage-row").length;i++){
				$(".home-tabpage-row")[i].style.margin = "0px 0px 0px 0px";
			}
			for(var i = 0;i<$(".qqbrowser-widgets-cells").length;i++){
				$(".qqbrowser-widgets-cells")[i].style.margin = "-10px 0px 0px 0px";
			}
			for(var i = 0;i<$(".cell-text").length;i++){
				$(".cell-text")[i].style.marginTop = "5px";
			}
			for(var i = 0;i<$(".empty .snapshot").length;i++){
				$(".empty .snapshot")[i].style.backgroundSize = "80px 56px";
			}
			for(var i = 0;i<snapshot.length;i++){
				snapshot[i].style.width = "192px";
				snapshot[i].style.height = "120px";
				snapshot[i].style.webkitBoxShadow = "0px 0px 5px hsla(210, 2%, 30%, 0.4)";
			}
			for(var i = 0;i<title.length;i++){
				title[i].style.width = "192px";
			}
		}
		else if(height <= 880){
            topsiteCells&&(topsiteCells.style.width = "900px");
			customsiteCells&&(customsiteCells.style.width = "900px");

			for(var i = 0;i<$(".home-tabpage-row").length;i++){
				$(".home-tabpage-row")[i].style.margin = "0px 0px 0px 0px";
			}
			for(var i = 0;i<$(".qqbrowser-widgets-cells").length;i++){
				$(".qqbrowser-widgets-cells")[i].style.margin = "12px 0px 0px 0px";
			}
			for(var i = 0;i<$(".cell-text").length;i++){
				$(".cell-text")[i].style.marginTop = "20px";
			}
			for(var i = 0;i<$(".empty .snapshot").length;i++){
				$(".empty .snapshot")[i].style.backgroundSize = "90px 63px";
			}
			for(var i = 0;i<snapshot.length;i++){
				snapshot[i].style.width = "224px";
				snapshot[i].style.height = "140px";
				snapshot[i].style.webkitBoxShadow = "0px 0px 8px hsla(210, 2%, 30%, 0.4)";
			}
			for(var i = 0;i<title.length;i++){
				title[i].style.width = "224px";
			}
		}else{
			topsiteCells&&(topsiteCells.style.width = "1140px");
			customsiteCells&&(customsiteCells.style.width = "1140px");
			for(var i = 0;i<$(".home-tabpage-row").length;i++){
				$(".home-tabpage-row")[i].style.margin = "0px 0px 10px 0px";
			}
			for(var i = 0;i<$(".qqbrowser-widgets-cells").length;i++){
				$(".qqbrowser-widgets-cells")[i].style.margin = "20px 0px 0px 0px";
			}
			for(var i = 0;i<$(".cell-text").length;i++){
				$(".cell-text")[i].style.marginTop = "45px";
			}
			for(var i = 0;i<$(".empty .snapshot").length;i++){
				$(".empty .snapshot")[i].style.backgroundSize = "100px 70px";
			}
			for(var i = 0;i<snapshot.length;i++){
				snapshot[i].style.width = "296px";
				snapshot[i].style.height = "185px";
				snapshot[i].style.webkitBoxShadow = "0px 0px 11px hsla(210, 2%, 30%, 0.4)";

			}
			for(var i = 0;i<title.length;i++){
				title[i].style.width = "296px";
			}
		}
		//scroll bug repaired
		if(width < 980){ 
			// 启用页面放大功能时，body的clientWidth会减小，当减小到980px以下时iframe的内容无法完全显示，故此固定其宽度
			document.body.style.width = "980px";
		}else{
			document.body.style.width = "";
		}
	},
	/**
	 * 导航
	 */
    loadSiteList: function(first){
		var frame = document.createElement("IFRAME");
		frame.id = 'iframe-website-navigation';
		frame.width ="990px";
		frame.height="1000px"; // 1426px
		frame.scrolling="no";
		frame.marginwidth= 0;
		frame.marginheight="0";
		frame.style.border="none";
		// frame.src = qqbrowser.extension.getAppDataPath() + '\\soso_site\\website\\index.html';
		// 0 SOSO导航本地页面路径
		// 1 注册表FreshInstall是否存在，0表示不存在；1表示存在
		var sosoDataPath = qqbrowser.extension.getSosoData(),
			installedOldVersion = qqbrowser.extension.getInstalledOldVersion();

		frame.src = sosoDataPath + '\\index.html?onLoadEnd=' + !first;
		// 新开QQ浏览器默认主页时，
		// 如果默认Tab是SOSO导航，则会触发qqbrowser.home.onLoadEnd事件，那么依赖onLoadEnd事件通知iframe页面可以安全的发网络请求了
		// 否则不会触发该事件，那么通过URL参数通知iframe页面，那么依赖onLoadEnd事件通知iframe页面可以安全的发网络请求了
		if (first) {
			qqbrowser.home.onLoadEnd.addListener(function() {
				frame.contentWindow.postMessage('onLoadEnd', '*');
			});
		}
		
		// 展示“导航页改版”的用户教育浮层
		if (first && Cube.String.compareVersion(installedOldVersion, '6.13') === -1) {
			var configKey = 'siteNavigationUpdateMask613HasShowed';
			qqbrowser.extension.builtin.config.get([configKey], function(jsonConfig) {
				var config = JSON.parse(jsonConfig),
					result = config[0];
				
				if (!result.hasOwnProperty(configKey) || result[configKey] === false) {
					// 展示浮层
					$('#mask')[0].style.display = 'block';
					document.body.classList.add('no-scroll');
					
					// 只要展示过一次，就不再展示了
					var config = {};
					config[configKey] = true;
					qqbrowser.extension.builtin.config.set(config, function() {});
				}
			});
		}

		this.hasLoadSites = true;
		$(".siteList")[0].appendChild(frame);
	},
	loadTerritory: function(){
		var frame = document.createElement("IFRAME");
		frame.width="980px";
		frame.height="520px";
		frame.scrolling="no";
		frame.marginwidth="0";
		frame.marginwidth="0";
		frame.marginheight="0";
		frame.style.border="none";
		frame.src = "territory.html";

		this.hasLoadTerritory = true;
		$(".territory")[0].appendChild(frame);
	},
	defaultTerritory: function(){
		var index = 2;
		for(var j=0;j< this._childPages.length;++j){
			qqbrowser.js.tools.utils.addClass(this._childPages[j],"hide");
			qqbrowser.js.tools.utils.removeClass(this._childPagesBind[j],"cur-page");
		};
		if(!qqbrowser.js.tools.utils.hasClass(this._childPagesBind[index],"cur-page")){
            if(!home.hasLoadTerritory){
                home.loadTerritory();
            }
			qqbrowser.js.tools.utils.removeClass(this._childPages[index],"hide");
			qqbrowser.js.tools.utils.addClass(this._childPagesBind[index],"cur-page");
			
			//子页面点击数据上报
			browser.dataReport.increase(DATAREPORT.STATIS_CMD_HOMEPAGE_QQHOME_MOST_VISITED_SHOW + index);
		}
		//调用外部设定的事件
		this._childPagesBindClick[index](event);
	},
	initCellsAnimate:function(){
		this.cellAnimateInited = true;
		var snapshot = $(".snapshot");
		var cellTitle = $(".cell-title");
		var customsiteCells = getId("customsiteCells");
		var topsiteCells = getId("topsiteCells");
		customsiteCells&&(customsiteCells.style.webkitTransition = "width 0.3s linear,height 0.3s linear");
		topsiteCells&&(topsiteCells.style.webkitTransition = "width 0.3s linear,height 0.3s linear");
		for(var i=0;i<snapshot.length;i++){
			snapshot[i].style.webkitTransition = "border 0.3s ease-in, -webkit-box-shadow 0.5s ease-in,width 0.3s linear,height 0.3s linear";
		}
		for(var i=0;i<cellTitle.length;i++){
			cellTitle[i].style.webkitTransition = "width 0.3s linear,height 0.3s linear";
		}
	},
	//处理相关换肤问题
	initSkin:function(){
		
	},
	//读取状态信息，只在新建页面时调用
    initStatus: function(){
    	this.status.setStatus('currentPage',parseInt(localStorage.getItem('currentPage')));
    	this.status.setStatus('currentCells',parseInt(localStorage.getItem('currentCells')));
		//兼容以前的版本
		if(localStorage.getItem('customMode')){
			if(localStorage.getItem('customMode') == "true"){
				this.status.setStatus('currentCells',1);
				localStorage.removeItem('customMode');
			}else if(localStorage.getItem('customMode') == "false"){
				this.status.setStatus('currentCells',0);
				localStorage.removeItem('customMode');
			}
		}
		switch(localStorage.getItem('hometab')){
			case "qqhot":
				this.status.setStatus('currentPage',1);
				localStorage.removeItem('hometab');
				break;
			case "qqhome":
				this.status.setStatus('currentPage',0);
				localStorage.removeItem('hometab');
				break;
			case "qqapp":
				this.status.setStatus('currentPage',2);
				localStorage.removeItem('hometab');
				break;
			default:
				break;
		}
		browser.config.get(['currentPage','currentCells'],function(returnData){
			// 如果在异步回调之前用户点击Tab，则记一个标志位，config的异步回调函数检测到标志位就跳出代码
			if (home.userClickFag) {
				return;
			}
			
			var data = JSON.parse(returnData)[0];
			
			if(data){
				//console.log(this);
				home.status.setStatus('currentPage',parseInt(data.currentPage));
				home.status.setStatus('currentCells',parseInt(data.currentCells));
				
				home._cellContainers = $(".cells>div");
				home._childPages = [$(".cells")[0],$(".siteList")[0],$(".territory")[0]];
				home._childPagesBind = $("#page-choose li");
				
				for(var j=0; j<home._cellContainers.length;++j){
					qqbrowser.js.tools.utils.removeClass($(".menu .menu-item")[j],"cur-menu-item");
					qqbrowser.js.tools.utils.addClass(home._cellContainers[j],"hide");
				}
				for(var j=0; j<home._childPagesBind.length;++j){
					qqbrowser.js.tools.utils.addClass(home._childPages[j],"hide");
					qqbrowser.js.tools.utils.removeClass(home._childPagesBind[j],"cur-page");
				}
				qqbrowser.js.tools.utils.removeClass(home._cellContainers[home.status.getStatus('currentCells')],"hide");
				qqbrowser.js.tools.utils.addClass($(".menu .menu-item")[home.status.getStatus('currentCells')],"cur-menu-item");
				var currentPage = home.status.getStatus('currentPage');
				qqbrowser.js.tools.utils.removeClass(home._childPages[currentPage],"hide");
				qqbrowser.js.tools.utils.addClass(home._childPagesBind[currentPage],"cur-page");
                if(currentPage == 1 && !home.hasLoadSites){
					home.loadSiteList();
				}else if(currentPage == 2 && !home.hasLoadTerritory){
					home.loadTerritory();
				}
				
				if (currentPage == 1) {
					document.getElementById('search-bar').style.display = 'none';
				} else {
					document.getElementById('search-bar').style.display = '';
				}
				
				var textNode;
				if(home.status.getStatus('currentCells') == 0){
					textNode = document.createTextNode("常用");
					$("#current-cells-item>span")[0].setAttribute("class","most-visited-icon");
				}else{
					textNode = document.createTextNode("自选");
					$("#current-cells-item>span")[0].setAttribute("class","my-fav-icon");
				}
				getId("current-cells-item").removeChild(getId("current-cells-item").childNodes[1]);
				getId("current-cells-item").appendChild(textNode);
			}
		});
    },
	//保存状态信息，考虑只在标签页关闭时调用
	saveStatus:function(){
		localStorage.setItem('currentPage',this.status.getStatus('currentPage'));
		localStorage.setItem('currentCells',this.status.getStatus('currentCells'));
		browser.config.set({currentPage:this.status.getStatus('currentPage')},function(data){console.log(data)});
		browser.config.set({currentCells:this.status.getStatus('currentCells')},function(data){console.log(data)});
	}
};